/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import proc.thema.Experiences;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.Timer;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TableExperiences extends JPanel implements Scrollable {

    private JPanel[] pExperiences;
    private JLabel[] lDesc;
    private JLabel[] lNbArticle;
    private JLabel[] lNbThema;
    private JLabel[] lDuree;
    private JLabel[] lPertinence;
    private JButton[] bRun;
    private JButton bRunAll;
    private Timer[] timerExperiences;
    private TableCorpus aActualiser;

    public TableExperiences(TableCorpus aActualiser) {
        this.aActualiser = aActualiser;
        int nbXP = Experiences.getExperiences().length;
        setLayout(new GridLayout(nbXP+1, 1, 5, 0));
        pExperiences = new JPanel[nbXP];
        lDesc = new JLabel[nbXP];
        lNbArticle = new JLabel[nbXP];
        lNbThema = new JLabel[nbXP];
        lDuree = new JLabel[nbXP];
        lPertinence = new JLabel[nbXP];
        bRun = new JButton[nbXP];
        timerExperiences = new Timer[nbXP];

        bRunAll = new JButton("Lancer toutes les expériences l'une après l'autre");
        JPanel pRunAll = new JPanel(new FlowLayout());
        pRunAll.add(bRunAll);
        add(pRunAll);
        bRunAll.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                lanceExperiences();
            }
        });

        for(int i=0; i<nbXP; i++){
            pExperiences[i] = new JPanel();
            pExperiences[i].setBorder(BorderFactory.createTitledBorder(
                    Experiences.getExperiences()[i].getTitre()));
            pExperiences[i].setLayout(new BorderLayout());
            lDesc[i] = new JLabel(Experiences.getExperiences()[i].getDesc());
            pExperiences[i].add(lDesc[i], BorderLayout.CENTER);
            JPanel pData = new JPanel(new BorderLayout());
            final int j = i+1;
            bRun[i] = new JButton("Lancer cette expérience");
            bRun[i].addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent arg0) {
                    lanceExperience(j);
                }
            });
            JPanel pRun = new JPanel();
            pRun.add(bRun[i]);
            pData.add(pRun, BorderLayout.NORTH);
            JPanel pData2 = new JPanel(new GridLayout(2,4));
            pData2.add(new JLabel("Lemmes côté articles : ", JLabel.RIGHT));
            lNbArticle[i] = new JLabel("0", JLabel.LEFT);
            pData2.add(lNbArticle[i]);
            pData2.add(new JLabel("Durée de l'expérience : ", JLabel.RIGHT));
            lDuree[i] = new JLabel("00:00:00", JLabel.LEFT);
            pData2.add(lDuree[i]);
            pData2.add(new JLabel("Lemmes côté thématiques : ", JLabel.RIGHT));
            lNbThema[i] = new JLabel("0", JLabel.LEFT);
            pData2.add(lNbThema[i]);
            pData2.add(new JLabel("Pertinence : ", JLabel.RIGHT));
            lPertinence[i] = new JLabel("0%", JLabel.LEFT);
            pData2.add(lPertinence[i]);
            pData.add(pData2, BorderLayout.SOUTH);
            pExperiences[i].add(pData, BorderLayout.SOUTH);
            add(pExperiences[i]);

            timerExperiences[i] = new Timer(1000, new ActionListener(){
                public void actionPerformed(ActionEvent ae){
                    majExperience(j);
                }
            });
        }

        Charte.formateAndFormateChildren(this);
    }

    private proc.thema.Experience[] listeExperiences = Experiences.getExperiences();
    public void completeExperiences(){
        int nbXP = Experiences.getExperiences().length;
        for(int i=0; i<nbXP; i++){
            pExperiences[i].setBorder(BorderFactory.createTitledBorder(
                    Experiences.getExperiences()[i].getTitre()));
            lDesc[i].setText(listeExperiences[i].getDesc());
            lNbArticle[i].setText(""+listeExperiences[i].getNbLemmesCoteArticle());
            lNbThema[i].setText(""+listeExperiences[i].getNbLemmesCoteThematique());
        }
    }

    private void lanceExperience(int numero){
        bRun[numero-1].setText("Expérience en cours");
        new Thread(listeExperiences[numero-1]).start();
        timerExperiences[numero-1].start();
    }

    private void lanceExperiences(){
        new Thread(){
            public void run() {
                int nbXP = Experiences.getExperiences().length;
                for (int i = 0; i < nbXP; i++) {
                    bRun[i].setText("Expérience en cours");
                    new Thread(listeExperiences[i]).start();
                    timerExperiences[i].start();
                    do {
                        try{
                            Thread.sleep(1000);
                        } catch(InterruptedException ie){

                        }
                    } while(!(listeExperiences[i].isTermine()));
                    timerExperiences[i].stop();
                    bRun[i].setText("Lancer cette expérience");
                    aActualiser.actualise();
                }
            }
        }.start();
    }

    private void majExperience(int numero){
        int elapsed = listeExperiences[numero-1].getSecondesExecution();
        String hr = "" + (elapsed / 3600);
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        String mn = "" + (elapsed % 3600 / 60);
        if (mn.length() < 2) {
            mn = "0" + mn;
        }
        String s = "" + (elapsed % 60);
        if (s.length() < 2) {
            s = "0" + s;
        }
        int pertinence = (int)(Math.floor(listeExperiences[numero-1].getPertinence()*100));
        lNbArticle[numero-1].setText(""+listeExperiences[numero-1].getNbLemmesCoteArticle());
        lNbThema[numero-1].setText(""+listeExperiences[numero-1].getNbLemmesCoteThematique());
        lDuree[numero-1].setText(hr+":"+mn+":"+s);
        lPertinence[numero-1].setText(pertinence+"%");
        bRun[numero-1].setText(listeExperiences[numero-1].getStatut());
        if(listeExperiences[numero-1].isTermine()){
            timerExperiences[numero-1].stop();
            aActualiser.actualise();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 10 * 60;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }
}
